<?php



/*

 * This file is part of the Symfony package.

 *

 * (c) Fabien Potencier <fabien@symfony.com>

 *

 * For the full copyright and license information, please view the LICENSE

 * file that was distributed with this source code.

 */



namespace Symfony\Component\Security\Core;



use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;



/**

 * The SecurityContextInterface.

 *

 * @author Johannes M. Schmitt <schmittjoh@gmail.com>

 */

interface SecurityContextInterface

{

    const ACCESS_DENIED_ERROR  = '_security.403_error';

    const AUTHENTICATION_ERROR = '_security.last_error';

    const LAST_USERNAME        = '_security.last_username';



    /**

     * Returns the current security token.

     *

     * @return TokenInterface|null A TokenInterface instance or null if no authentication information is available

     */

    public function getToken();



    /**

     * Sets the authentication token.

     *

     * @param TokenInterface $token A TokenInterface token, or null if no further authentication information should be stored

     */

    public function setToken(TokenInterface $token = null);



    /**

     * Checks if the attributes are granted against the current authentication token and optionally supplied object.

     *

     * @param mixed $attributes

     * @param mixed $object

     *

     * @return bool

     */

    public function isGranted($attributes, $object = null);

}

