<?php



/*

 * This file is part of the Symfony package.

 *

 * (c) Fabien Potencier <fabien@symfony.com>

 *

 * For the full copyright and license information, please view the LICENSE

 * file that was distributed with this source code.

 */



namespace Symfony\Component\Routing\Matcher\Dumper;



use Symfony\Component\Routing\RouteCollection;



/**

 * MatcherDumperInterface is the interface that all matcher dumper classes must implement.

 *

 * @author Fabien Potencier <fabien@symfony.com>

 */

interface MatcherDumperInterface

{

    /**

     * Dumps a set of routes to a string representation of executable code

     * that can then be used to match a request against these routes.

     *

     * @param array $options An array of options

     *

     * @return string Executable code

     */

    public function dump(array $options = array());



    /**

     * Gets the routes to dump.

     *

     * @return RouteCollection A RouteCollection instance

     */

    public function getRoutes();

}

