<?php



/*

 * This file is part of the Symfony package.

 *

 * (c) Fabien Potencier <fabien@symfony.com>

 *

 * For the full copyright and license information, please view the LICENSE

 * file that was distributed with this source code.

 */



namespace Symfony\Component\CssSelector\Node;



/**

 * Represents a combined node.

 *

 * This component is a port of the Python cssselector library,

 * which is copyright Ian Bicking, @see https://github.com/SimonSapin/cssselect.

 *

 * @author Jean-François Simon <jeanfrancois.simon@sensiolabs.com>

 */

class CombinedSelectorNode extends AbstractNode

{

    /**

     * @var NodeInterface

     */

    private $selector;



    /**

     * @var string

     */

    private $combinator;



    /**

     * @var NodeInterface

     */

    private $subSelector;



    /**

     * @param NodeInterface $selector

     * @param string        $combinator

     * @param NodeInterface $subSelector

     */

    public function __construct(NodeInterface $selector, $combinator, NodeInterface $subSelector)

    {

        $this->selector = $selector;

        $this->combinator = $combinator;

        $this->subSelector = $subSelector;

    }



    /**

     * @return NodeInterface

     */

    public function getSelector()

    {

        return $this->selector;

    }



    /**

     * @return string

     */

    public function getCombinator()

    {

        return $this->combinator;

    }



    /**

     * @return NodeInterface

     */

    public function getSubSelector()

    {

        return $this->subSelector;

    }



    /**

     * {@inheritdoc}

     */

    public function getSpecificity()

    {

        return $this->selector->getSpecificity()->plus($this->subSelector->getSpecificity());

    }



    /**

     * {@inheritdoc}

     */

    public function __toString()

    {

        $combinator = ' ' === $this->combinator ? '<followed>' : $this->combinator;



        return sprintf('%s[%s %s %s]', $this->getNodeName(), $this->selector, $combinator, $this->subSelector);

    }

}

