<?php



/*

 * This file is part of the Predis package.

 *

 * (c) Daniele Alessandri <suppakilla@gmail.com>

 *

 * For the full copyright and license information, please view the LICENSE

 * file that was distributed with this source code.

 */



namespace Predis\Command;



/**

 * @group commands

 * @group realm-list

 */

class ListPopFirstTest extends PredisCommandTestCase

{

    /**

     * {@inheritdoc}

     */

    protected function getExpectedCommand()

    {

        return 'Predis\Command\ListPopFirst';

    }



    /**

     * {@inheritdoc}

     */

    protected function getExpectedId()

    {

        return 'LPOP';

    }



    /**

     * @group disconnected

     */

    public function testFilterArguments()

    {

        $arguments = array('key');

        $expected = array('key');



        $command = $this->getCommand();

        $command->setArguments($arguments);



        $this->assertSame($expected, $command->getArguments());

    }



    /**

     * @group disconnected

     */

    public function testParseResponse()

    {

        $this->assertSame('element', $this->getCommand()->parseResponse('element'));

    }



    /**

     * @group disconnected

     */

    public function testPrefixKeys()

    {

        $arguments = array('key');

        $expected = array('prefix:key');



        $command = $this->getCommandWithArgumentsArray($arguments);

        $command->prefixKeys('prefix:');



        $this->assertSame($expected, $command->getArguments());

    }



    /**

     * @group disconnected

     */

    public function testPrefixKeysIgnoredOnEmptyArguments()

    {

        $command = $this->getCommand();

        $command->prefixKeys('prefix:');



        $this->assertSame(array(), $command->getArguments());

    }



    /**

     * @group connected

     */

    public function testPopsTheFirstElementFromList()

    {

        $redis = $this->getClient();



        $redis->rpush('letters', 'a', 'b', 'c', 'd');



        $this->assertSame('a', $redis->lpop('letters'));

        $this->assertSame('b', $redis->lpop('letters'));

        $this->assertSame(array('c', 'd'), $redis->lrange('letters', 0, -1));

    }



    /**

     * @group connected

     */

    public function testReturnsNullOnEmptyList()

    {

        $redis = $this->getClient();



        $this->assertNull($redis->lpop('letters'));

    }



    /**

     * @group connected

     * @expectedException Predis\ServerException

     * @expectedExceptionMessage Operation against a key holding the wrong kind of value

     */

    public function testThrowsExceptionOnWrongType()

    {

        $redis = $this->getClient();



        $redis->set('foo', 'bar');

        $redis->lpop('foo');

    }

}

