<?php



/*

 * This file is part of the Predis package.

 *

 * (c) Daniele Alessandri <suppakilla@gmail.com>

 *

 * For the full copyright and license information, please view the LICENSE

 * file that was distributed with this source code.

 */



namespace Predis\Command;



/**

 * @link http://redis.io/commands/zunionstore

 * @author Daniele Alessandri <suppakilla@gmail.com>

 */

class ZSetUnionStore extends PrefixableCommand

{

    /**

     * {@inheritdoc}

     */

    public function getId()

    {

        return 'ZUNIONSTORE';

    }



    /**

     * {@inheritdoc}

     */

    protected function filterArguments(Array $arguments)

    {

        $options = array();

        $argc = count($arguments);



        if ($argc > 2 && is_array($arguments[$argc - 1])) {

            $options = $this->prepareOptions(array_pop($arguments));

        }



        if (is_array($arguments[1])) {

            $arguments = array_merge(

                array($arguments[0], count($arguments[1])),

                $arguments[1]

            );

        }



        return array_merge($arguments, $options);

    }



    /**

     * Returns a list of options and modifiers compatible with Redis.

     *

     * @param  array $options List of options.

     * @return array

     */

    private function prepareOptions($options)

    {

        $opts = array_change_key_case($options, CASE_UPPER);

        $finalizedOpts = array();



        if (isset($opts['WEIGHTS']) && is_array($opts['WEIGHTS'])) {

            $finalizedOpts[] = 'WEIGHTS';



            foreach ($opts['WEIGHTS'] as $weight) {

                $finalizedOpts[] = $weight;

            }

        }



        if (isset($opts['AGGREGATE'])) {

            $finalizedOpts[] = 'AGGREGATE';

            $finalizedOpts[] = $opts['AGGREGATE'];

        }



        return $finalizedOpts;

    }



    /**

     * {@inheritdoc}

     */

    public function prefixKeys($prefix)

    {

        if ($arguments = $this->getArguments()) {

            $arguments[0] = "$prefix{$arguments[0]}";

            $length = ((int) $arguments[1]) + 2;



            for ($i = 2; $i < $length; $i++) {

                $arguments[$i] = "$prefix{$arguments[$i]}";

            }



            $this->setRawArguments($arguments);

        }

    }

}

