<?php namespace Illuminate\Cache;



class WinCacheStore extends TaggableStore implements StoreInterface {



	/**

	 * A string that should be prepended to keys.

	 *

	 * @var string

	 */

	protected $prefix;



	/**

	 * Create a new WinCache store.

	 *

	 * @param  string     $prefix

	 * @return void

	 */

	public function __construct($prefix = '')

	{

		$this->prefix = $prefix;

	}



	/**

	 * Retrieve an item from the cache by key.

	 *

	 * @param  string  $key

	 * @return mixed

	 */

	public function get($key)

	{

		$value = wincache_ucache_get($this->prefix.$key);



		if ($value !== false)

		{

			return $value;

		}

	}



	/**

	 * Store an item in the cache for a given number of minutes.

	 *

	 * @param  string  $key

	 * @param  mixed   $value

	 * @param  int     $minutes

	 * @return void

	 */

	public function put($key, $value, $minutes)

	{

		wincache_ucache_set($this->prefix.$key, $value, $minutes * 60);

	}



	/**

	 * Increment the value of an item in the cache.

	 *

	 * @param  string  $key

	 * @param  mixed   $value

	 * @return void

	 */

	public function increment($key, $value = 1)

	{

		return wincache_ucache_inc($this->prefix.$key, $value);

	}



	/**

	 * Increment the value of an item in the cache.

	 *

	 * @param  string  $key

	 * @param  mixed   $value

	 * @return void

	 */

	public function decrement($key, $value = 1)

	{

		return wincache_ucache_dec($this->prefix.$key, $value);

	}



	/**

	 * Store an item in the cache indefinitely.

	 *

	 * @param  string  $key

	 * @param  mixed   $value

	 * @return void

	 */

	public function forever($key, $value)

	{

		return $this->put($key, $value, 0);

	}



	/**

	 * Remove an item from the cache.

	 *

	 * @param  string  $key

	 * @return void

	 */

	public function forget($key)

	{

		wincache_ucache_delete($this->prefix.$key);

	}



	/**

	 * Remove all items from the cache.

	 *

	 * @return void

	 */

	public function flush()

	{

		wincache_ucache_clear();

	}



	/**

	 * Get the cache key prefix.

	 *

	 * @return string

	 */

	public function getPrefix()

	{

		return $this->prefix;

	}



}

