<?php

/*

 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS

 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT

 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR

 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT

 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,

 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT

 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,

 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY

 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT

 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE

 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 *

 * This software consists of voluntary contributions made by many individuals

 * and is licensed under the MIT license. For more information, see

 * <http://www.doctrine-project.org>.

 */



namespace Doctrine\DBAL\Driver\IBMDB2;



use Doctrine\DBAL\Driver;

use Doctrine\DBAL\Connection;



/**

 * IBM DB2 Driver.

 *

 * @since 2.0

 * @author Benjamin Eberlei <kontakt@beberlei.de>

 */

class DB2Driver implements Driver

{

    /**

     * {@inheritdoc}

     */

    public function connect(array $params, $username = null, $password = null, array $driverOptions = array())

    {

        if ( ! isset($params['protocol'])) {

            $params['protocol'] = 'TCPIP';

        }



        if ($params['host'] !== 'localhost' && $params['host'] != '127.0.0.1') {

            // if the host isn't localhost, use extended connection params

            $params['dbname'] = 'DRIVER={IBM DB2 ODBC DRIVER}' .

                     ';DATABASE=' . $params['dbname'] .

                     ';HOSTNAME=' . $params['host'] .

                     ';PROTOCOL=' . $params['protocol'] .

                     ';UID='      . $username .

                     ';PWD='      . $password .';';

            if (isset($params['port'])) {

                $params['dbname'] .= 'PORT=' . $params['port'];

            }



            $username = null;

            $password = null;

        }



        return new DB2Connection($params, $username, $password, $driverOptions);

    }



    /**

     * {@inheritdoc}

     */

    public function getDatabasePlatform()

    {

        return new \Doctrine\DBAL\Platforms\DB2Platform;

    }



    /**

     * {@inheritdoc}

     */

    public function getSchemaManager(Connection $conn)

    {

        return new \Doctrine\DBAL\Schema\DB2SchemaManager($conn);

    }



    /**

     * {@inheritdoc}

     */

    public function getName()

    {

        return 'ibm_db2';

    }



    /**

     * {@inheritdoc}

     */

    public function getDatabase(\Doctrine\DBAL\Connection $conn)

    {

        $params = $conn->getParams();



        return $params['dbname'];

    }

}

