<?php

/*

 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS

 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT

 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR

 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT

 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,

 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT

 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,

 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY

 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT

 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE

 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 *

 * This software consists of voluntary contributions made by many individuals

 * and is licensed under the MIT license. For more information, see

 * <http://www.doctrine-project.org>.

 */



namespace Doctrine\Common\Proxy\Exception;



use Doctrine\Common\Persistence\Proxy;

use InvalidArgumentException as BaseInvalidArgumentException;



/**

 * Proxy Invalid Argument Exception.

 *

 * @link   www.doctrine-project.org

 * @since  2.4

 * @author Marco Pivetta <ocramius@gmail.com>

 */

class InvalidArgumentException extends BaseInvalidArgumentException implements ProxyException

{

    /**

     * @return self

     */

    public static function proxyDirectoryRequired()

    {

        return new self('You must configure a proxy directory. See docs for details');

    }



    /**

     * @param string $className

     * @param string $proxyNamespace

     *

     * @return self

     */

    public static function notProxyClass($className, $proxyNamespace)

    {

        return new self(sprintf('The class "%s" is not part of the proxy namespace "%s"', $className, $proxyNamespace));

    }



    /**

     * @param string $name

     *

     * @return self

     */

    public static function invalidPlaceholder($name)

    {

        return new self(sprintf('Provided placeholder for "%s" must be either a string or a valid callable', $name));

    }



    /**

     * @return self

     */

    public static function proxyNamespaceRequired()

    {

        return new self('You must configure a proxy namespace');

    }



    /**

     * @return self

     */

    public static function unitializedProxyExpected(Proxy $proxy)

    {

        return new self(sprintf('Provided proxy of type "%s" must not be initialized.', get_class($proxy)));

    }



    /**

     * @param mixed $callback

     *

     * @return self

     */

    public static function invalidClassNotFoundCallback($callback)

    {

        $type = is_object($callback) ? get_class($callback) : gettype($callback);



        return new self(sprintf('Invalid \$notFoundCallback given: must be a callable, "%s" given', $type));

    }

}

