define([

	"../core",

	"../var/support"

], function( jQuery, support ) {



(function() {

	var pixelPositionVal, boxSizingReliableVal,

		docElem = document.documentElement,

		container = document.createElement( "div" ),

		div = document.createElement( "div" );



	if ( !div.style ) {

		return;

	}



	div.style.backgroundClip = "content-box";

	div.cloneNode( true ).style.backgroundClip = "";

	support.clearCloneStyle = div.style.backgroundClip === "content-box";



	container.style.cssText = "border:0;width:0;height:0;top:0;left:-9999px;margin-top:1px;" +

		"position:absolute";

	container.appendChild( div );



	// Executing both pixelPosition & boxSizingReliable tests require only one layout

	// so they're executed at the same time to save the second computation.

	function computePixelPositionAndBoxSizingReliable() {

		div.style.cssText =

			// Support: Firefox<29, Android 2.3

			// Vendor-prefix box-sizing

			"-webkit-box-sizing:border-box;-moz-box-sizing:border-box;" +

			"box-sizing:border-box;display:block;margin-top:1%;top:1%;" +

			"border:1px;padding:1px;width:4px;position:absolute";

		div.innerHTML = "";

		docElem.appendChild( container );



		var divStyle = window.getComputedStyle( div, null );

		pixelPositionVal = divStyle.top !== "1%";

		boxSizingReliableVal = divStyle.width === "4px";



		docElem.removeChild( container );

	}



	// Support: node.js jsdom

	// Don't assume that getComputedStyle is a property of the global object

	if ( window.getComputedStyle ) {

		jQuery.extend( support, {

			pixelPosition: function() {

				// This test is executed only once but we still do memoizing

				// since we can use the boxSizingReliable pre-computing.

				// No need to check if the test was already performed, though.

				computePixelPositionAndBoxSizingReliable();

				return pixelPositionVal;

			},

			boxSizingReliable: function() {

				if ( boxSizingReliableVal == null ) {

					computePixelPositionAndBoxSizingReliable();

				}

				return boxSizingReliableVal;

			},

			reliableMarginRight: function() {

				// Support: Android 2.3

				// Check if div with explicit width and no margin-right incorrectly

				// gets computed margin-right based on width of container. (#3333)

				// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right

				// This support function is only executed once so no memoizing is needed.

				var ret,

					marginDiv = div.appendChild( document.createElement( "div" ) );



				// Reset CSS: box-sizing; display; margin; border; padding

				marginDiv.style.cssText = div.style.cssText =

					// Support: Firefox<29, Android 2.3

					// Vendor-prefix box-sizing

					"-webkit-box-sizing:content-box;-moz-box-sizing:content-box;" +

					"box-sizing:content-box;display:block;margin:0;border:0;padding:0";

				marginDiv.style.marginRight = marginDiv.style.width = "0";

				div.style.width = "1px";

				docElem.appendChild( container );



				ret = !parseFloat( window.getComputedStyle( marginDiv, null ).marginRight );



				docElem.removeChild( container );



				return ret;

			}

		});

	}

})();



return support;



});

