<?php



use Illuminate\Auth\UserInterface;

use Illuminate\Auth\Reminders\RemindableInterface;



class User extends Eloquent implements UserInterface, RemindableInterface {



	/**

	 * The database table used by the model.

	 *

	 * @var string

	 */

    public static $unguarded = true;



    protected $table = 'users';







    public static function getAvatar($user_id = false)

    {

        if($user_id){

            $avatar = self::where('id', $user_id)->pluck('avatar');

        }else{

            $avatar = Auth::User()->avatar;

        }



        if($avatar){

            return 'static/userdata/avatar/'.$avatar;

        }else{

            return asset('static/admin/'.Option::value('publicTheme').'/img/avatar.png');

        }



    }





	/**

	 * The attributes excluded from the model's JSON form.

	 *

	 * @var array

	 */

	protected $hidden = array('password');



	/**

	 * Get the unique identifier for the user.

	 *

	 * @return mixed

	 */

	public function getAuthIdentifier()

	{

		return $this->getKey();

	}



	/**

	 * Get the password for the user.

	 *

	 * @return string

	 */

	public function getAuthPassword()

	{

		return $this->password;

	}



	/**

	 * Get the token value for the "remember me" session.

	 *

	 * @return string

	 */

	public function getRememberToken()

	{

		return $this->remember_token;

	}



	/**

	 * Set the token value for the "remember me" session.

	 *

	 * @param  string  $value

	 * @return void

	 */

	public function setRememberToken($value)

	{

		$this->remember_token = $value;

	}



	/**

	 * Get the column name for the "remember me" token.

	 *

	 * @return string

	 */

	public function getRememberTokenName()

	{

		return 'remember_token';

	}



	/**

	 * Get the e-mail address where password reminders are sent.

	 *

	 * @return string

	 */

	public function getReminderEmail()

	{

		return $this->email;

	}



}

