<?php





class Option extends Eloquent {



    public static $unguarded = true;



	protected $table = 'options';





    public static function value($option){



		if(Cache::has($option)){

			return Cache::get($option);

		}

        $re = self::where('option', $option)->pluck('value');

		Cache::put($option, $re, 60*60);

		return $re;

    }



    public function group(){

        $this->hasOne('OptionGroup', 'id', 'group_id');

    }



    public static function getList($class, $method){

        return call_user_func(array($class, $method));

    }





    public static function renderForm($option){



        if($option->type == 'text'){

            return '<input value="'.$option->value.'" type="text" class="form-control" id="'.$option->option.'" name="'.$option->option.'" placeholder="'.$option->description.'">';

        }



        if($option->type == 'int'){

            return '<input value="'.$option->value.'" id="'.$option->option.'" name="'.$option->option.'" type="number" class="form-control">';

        }



        if($option->type == 'float'){

            return '<input step="0.01" value="'.$option->value.'" id="'.$option->option.'" name="'.$option->option.'" type="number" class="form-control">';

        }



        if($option->type == 'select'){



            if($option->selectList){

                $lists = json_decode($option->selectList);

            }

            else{

                $lists = self::getList($option->selectListClass, $option->selectListMethod);

            }



            $holder = '';

            foreach($lists as $list){

                if($option->value == $list['value']){

                    $holder .= '<option selected value="'.$list['value'].'">'.$list['name'].'</option>';

                }

                else{

                    $holder .= '<option value="'.$list['value'].'">'.$list['name'].'</option>';

                }

            }



            return '<select class="form-control" id="'.$option->option.'" name="'.$option->option.'">'.$holder.'</select>';

        }





    }





}

