<?php



Event::listen('illuminate.query', function($query, $bindings, $time, $name)

    {

        $data = compact('bindings', 'time', 'name');



        // Format binding data for sql insertion

        foreach ($bindings as $i => $binding)

        {   

            if ($binding instanceof \DateTime)

            {   

                $bindings[$i] = $binding->format('\'Y-m-d H:i:s\'');

            }

            else if (is_string($binding))

            {   

                $bindings[$i] = "'$binding'";

            }   

        }       



        // Insert bindings into query

        $query = str_replace(array('%', '?'), array('%%', '%s'), $query);

        $query = vsprintf($query, $bindings); 



        Log::info($query, $data);

    });





/*

|--------------------------------------------------------------------------

| Application & Route Filters

|--------------------------------------------------------------------------

|

| Below you will find the "before" and "after" events for the application

| which may be used to do any work before or after a request into your

| application. Here you may also register your custom route filters.

|

*/



App::before(function($request)

{



});





App::after(function($request, $response)

{



});



/*

|--------------------------------------------------------------------------

| Authentication Filters

|--------------------------------------------------------------------------

|

| The following filters are used to verify that the user of the current

| session is logged into this application. The "basic" filter easily

| integrates HTTP Basic authentication for quick, simple checking.

|

*/



Route::filter('auth', function()

{

    if (Auth::guest()) return Redirect::to('login');

});





Route::filter('auth.basic', function()

{

	return Auth::basic();

});





Route::filter('admin', function()

{

    if(!Auth::user()->is_admin) Redirect::to('login');

});





/*

|--------------------------------------------------------------------------

| Guest Filter

|--------------------------------------------------------------------------

|

| The "guest" filter is the counterpart of the authentication filters as

| it simply checks that the current user is not logged in. A redirect

| response will be issued if they are, which you may freely change.

|

*/



Route::filter('guest', function()

{

	if (Auth::check()) return Redirect::to('/');

});



/*

|--------------------------------------------------------------------------

| CSRF Protection Filter

|--------------------------------------------------------------------------

|

| The CSRF filter is responsible for protecting your application against

| cross-site request forgery attacks. If this special token in a user

| session does not match the one given in this request, we'll bail.

|

*/



Route::filter('csrf', function()

{

	if (Session::token() != Input::get('_token'))

	{

		throw new Illuminate\Session\TokenMismatchException;

	}

});





if(!Session::has('lang_id')) Session::set('lang_id', 1000);





View::share('_user', Auth::user());

View::share('_atheme', Option::value('adminTheme'));

View::share('_ptheme', Option::value('publicTheme'));