@extends('layouts.wrap')

@section('title', 'Ürünler')

@include('product::sidebar')


@section('_content')
<div id="component_page">
    <h1 class="title">Ürünler Komponenti</h1>

    @if(Session::has('message'))
    <div class="alert alert-success">{{ Session::get('message') }}</div>
    @endif
    @if($product->count() > 0)
    <table class="table table-hover table-striped">
        <thead>
        <tr>
            <th>Başlık</th>
            <th>Kategori</th>
            <th>Eklenme Tarihi</th>
        </tr>
        </thead>
        <tbody>
        @foreach($product as $p)
        <tr>
            <td><a href="{{ URL::to('component/product/edit/'. $p->id) }}">{{ $p->title }}<a></td>
            <td>{{ $p->category->title }}</td>
            <td><abbr class="timeago" title="{{ $p->created_at }}">{{ $p->created_at }}</abbr></td>
        </tr>
        @endforeach
        </tbody>
    </table>

    {{ $product->links() }}
    @else
    <div class="alert alert-warning">
        <h4>Hiç Ürün yok.</h4> <a href="{{ URL::to('component/product/create') }}" class="alert-link">Buradan ekleyin</a>
    </div>
    @endif


</div>
@stop