@extends('layouts.wrap')

@section('title', $product->title)

@include('product::sidebar')

@section('foot_hook')
@parent
<script>
    CKEDITOR.replace('description', {
        filebrowserUploadUrl: '/component/page/uploader',
        height: '100px'
    });
</script>
@stop


@include('assets.form.ckeditor')

@section('_content')

<h1 class="title clearfix">{{ $product->title }}  <a href="{{ URL::to('component/product/delete/'.$product->id) }}" class="btn btn-danger btn-xs pull-right"><i class="fa fa-trash-o"></i> Ürünü Kaldır</a></h1>

{{ Former::open_for_files()->method('POST')->action(URL::to('component/product/edit/'.$product->id)) }}

{{ Former::text('title')->label('Ürün Başlığı')->placeholder('Ürün Başlığı')->required(true)->value($product->title) }}

{{ Former::select('category_id')->options($category, $product->category_id)->label('Ürün Kategorisi') }}

<div class="form-group">
    <label for="title" class="control-label">Ürün Görseli</label>
    <input type="file" id="image" name="image" multiple accept="image/*">
</div>

{{ Former::textarea('description')->label('Ürün Açıklaması')->value($product->description) }}
<button type="submit" class="btn btn-danger">Değişiklikleri Kaydet</button>

{{ Former::close() }}

@stop