@extends('layouts.wrap')

@section('title', 'Yeni Ürün')

@include('product::sidebar')

@section('foot_hook')
@parent
<script>


    CKEDITOR.replace('description', {
        filebrowserUploadUrl: '/component/page/uploader/{{Request::segment(4)}}',
        height: '100px'
    });


</script>
@stop

@include('assets.form.ckeditor')




@section('_content')

<h1 class="title">Yeni Ürün</h1>

{{ Former::open_for_files()->method('POST')->action(URL::to('component/product/create')) }}

{{ Former::text('title')->label('Ürün Başlığı')->placeholder('Ürün Başlığı')->required(true) }}

{{ Former::select('category_id')->options($category)->label('Ürün Kategorisi') }}

<div class="form-group">
    <label for="title" class="control-label">Ürün Görseli</label>
    <input type="file" id="image" name="image" multiple accept="image/*">
</div>


{{ Former::textarea('description')->label('Ürün Açıklaması') }}

<button type="submit" class="btn btn-danger">Oluştur</button>


{{ Former::close() }}

@stop