@extends('layouts.wrap')





@section('title', 'Kategoriler')








@include('page::sidebar')








@section('_content')


<div id="component_page">


    <h1 class="title">Sayfa Kategorileri</h1>





    @if(Session::has('message'))


    <div class="alert alert-success">{{ Session::get('message') }}</div>


    @endif


    @if($category->count() > 0)


    <table class="table table-hover table-striped">


        <thead>


        <tr>


            <th>Başlık</th>


            <th>Açıklama</th>


        </tr>


        </thead>


        <tbody>


        @foreach($category as $p)


        <tr>


            <td><a href="{{ URL::to('component/page/categoryedit/'. $p->id) }}">{{ $p->title }}<a></td>


            <td>{{ $p->description }}</td>


        </tr>


        @endforeach


        </tbody>


    </table>





    {{ $category->links() }}


    @else


    <div class="alert alert-warning">


        <h4>Hiç Kategoriniz yok.</h4> <a href="{{ URL::to('component/page/createcategory') }}" class="alert-link">Buradan ekleyin</a>


    </div>


    @endif








</div>





@stop