<?php



class PageController extends \BaseController {





	public function getIndex()

	{

        $data['page'] = Page::paginate(Option::value('admin_paginate'));

        return view::make('page::home', $data);

	}







	public function getCreate()

	{

        return View::make('page::create');

	}





    public function getEdit($id){

        $data['page'] = Page::findOrFail($id);



        return View::make('page::edit', $data);

    }



    public function postEdit($id){



        $validator = Validator::make(Input::all(), [



            'title' => 'required',

            'url' => 'required',

            'description' => 'required',

            'component_id' => 'required'

        ]);



        if($validator->passes()){

            $page = Page::findOrFail($id);

            $page->title =  Input::get('title');

            $page->url = Input::get('url');

            $page->description = Input::get('description');

            $page->component_id = Input::get('component_id');

            $page->lang = Session::get('lang_id');

            $page->user_id = Auth::user()->id;

            $page->category_id = Input::get('category_id');

            $page->save();



            return Redirect::to('component/page/component/'.$page->id);

        }else{

            return Redirect::back()->withInput(Input::all())->withErrors($validator->messages());

        }



    }





    public function postCreate(){



        $validator = Validator::make(Input::all(), [



            'title' => 'required',

            'url' => 'required',

            'description' => 'required',

            'component_id' => 'required'

        ]);





        if($validator->passes()){

            $page = Page::create([

                'title' => Input::get('title'),

                'url' => Input::get('url'),

                'description' => Input::get('description'),

                'component_id' => Input::get('component_id'),

                'lang' => Session::get('lang_id'),

                'user_id' => Auth::user()->id,

                'category_id' => Input::get('category_id')

            ]);

            return Redirect::to('component/page/component/'.$page->id);

        }else{

            return Redirect::back()->withInput(Input::all())->withErrors($validator->messages());

        }



    }



    public function getComponent($id){



        $page = Page::findOrFail($id);



        if(!$page->component->is_item) return Redirect::to('component/page');



        if($page->component->module == 'Page'){

            $data['ckeditor'] = true;

        }



        $data['page'] = $page;

        $data['item'] = call_user_func($page->component->module.'::lists', 'title', 'id');



        return view::make('page::component', $data);



    }



    public function postUploader($id){



        $validator = Validator::make(Input::all(), [

            'upload' => 'image|required'

        ]);



        if($validator->passes()){

            $filename = str_random(16);

            Input::file('upload')->move('modules/page/page/'.$id.'/', $filename.'.'.Input::file('upload')->getClientOriginalExtension());

            return '<script>window.parent.CKEDITOR.tools.callFunction("'.Input::get('CKEditorFuncNum').'", "'.URL::to('modules/page/page/'.$id.'/', $filename.'.'.Input::file('upload')->getClientOriginalExtension()).'");</script>';

        }

        return false;

    }





    public function postSave($id){



        $page = Page::findOrFail($id);



        if($page->component->module == 'Page'){

            $rule = ['value' => 'required'];

        }else{

            $rule = ['component_item' => 'required'];

        }

        $validator = Validator::make(Input::all(), $rule);



        if($validator->passes()){

            $page->value = Input::get('value');

            $page->component_item = Input::get('component_item');

            $page->save();

            return Redirect::to('component/page');

        }

        else{

            return Redirect::back()->withErrors($validator->messages())->withInput(Input::all());

        }





    }





    public function getCategory(){

        $data['category'] = PageCategory::paginate(Option::value('admin_paginate'));

        return View::make('page::category', $data);

    }



    public function getCreatecategory(){

        return view::make('page::createcategory');

    }



    public function postCreatecategory(){



       $validator = Validator::make(Input::all(), [

           'title' => 'required',

           'description' => 'required'

       ]);



       if($validator->passes()){



           PageCategory::create([

               'title' => Input::get('title'),

               'description' => Input::get('description')

           ]);



           return Redirect::to('component/page/category')->with('message', 'Kategori Başarıyla oluşturuldu');



       }

        return Redirect::back()->withInput(Input::all())->withErrors($validator->messages());

    }





    public function getCategoryedit($id){



        $data['category'] = PageCategory::findOrFail($id);

        return View::make('page::editcategory', $data);



    }



    public function postCategoryedit($id){



        $cat =  PageCategory::findOrFail($id);



        $validator = Validator::make(Input::all(), [

            'title' => 'required',

            'description' => 'required'

        ]);



        if($validator->passes()){

            $cat->title = Input::get('title');

            $cat->description = Input::get('description');

            $cat->save();

            return Redirect::to('component/page/category')->with('message', 'Kategori Başarıyla Düzenlendi');

        }

        return Redirect::back()->withInput(Input::all())->withErrors($validator->messages());



    }









}

