@extends('layouts.wrap')



@section('title', 'Haberler')



@include('news::sidebar')





@section('_content')

<div id="component_page">

    <h1 class="title">Haberler Komponenti</h1>



    @if(Session::has('message'))

    <div class="alert alert-success">{{ Session::get('message') }}</div>

    @endif

    @if($news->count() > 0)

    <table class="table table-hover table-striped">

        <thead>

        <tr>

            <th>Başlık</th>

            <th>Tarih</th>

        </tr>

        </thead>

        <tbody>

        @foreach($news as $n)

        <tr>

            <td><a href="{{ URL::to('component/news/edit/'. $n->id) }}">{{ $n->title }}<a></td>

            <td>{{ $n->created_at }}</td>

        </tr>

        @endforeach

        </tbody>

    </table>



    {{ $news->links() }}

    @else

    <div class="alert alert-warning">

        <h4>Hiç Haberiniz yok.</h4> <a href="{{ URL::to('component/news/create') }}" class="alert-link">Buradan ekleyin</a>

    </div>

    @endif





</div>



@stop