@extends('layouts.wrap')



@section('title', $news->title)



@include('news::sidebar')



@section('foot_hook')

@parent

<script>

    CKEDITOR.replace('value', {

        filebrowserUploadUrl: '/component/news/uploader',

        height: '400px'

    });

</script>

@stop



@include('assets.form.ckeditor')



@section('_content')


<h1 class="title">{{ $news->title}} - Düzenle <a  data-toggle="modal" data-target="#confirm-delete" class="pull-right btn-xs btn-danger btn"><i class="fa fa-trash-o"></i> Haberi Sil</a></h1>

<h1 class="title">{{ $news->title }}</h1>



{{ Former::open_for_files()->method('POST')->action(URL::to('component/news/edit/'.$news->id)) }}



{{ Former::text('title')->label('Başlık')->placeholder('Başlık')->required(true)->value($news->title) }}



<div class="form-group">

    <img src="{{ asset('modules/news/news/'.$news->cover) }}" height="200">

</div>



<div class="form-group">

    <label for="title" class="control-label">Kapak Resmi</label>

    <input type="file" id="cover" name="cover" multiple accept="image/*">

</div>



<div class="form-group">

    <textarea id="value" name="value" class="form-control">

        {{ $news->value }}

    </textarea>

</div>



<button type="submit" class="btn btn-danger">Değişiklikleri Kaydet</button>



{{ Former::close() }}




<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title" id="myModalLabel">Silmeyi Onaylıyormusun ?</h4>
            </div>

            <div class="modal-body">
                <p>İşleme devam edilsin mi?</p>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Hayır</button>
                <a href="{{ URL::to('component/news/delete/'.$news->id) }}" class="btn btn-danger danger">Sil</a>
            </div>
        </div>
    </div>
</div>


@stop