@extends('layouts.wrap')





@section('title', Option::value('siteTitle').' - Yönetim')








@include('gallery::sidebar')








@section('_content')


    <div id="component_gallery">


<h1 class="title">Galeri Komponenti</h1>





        @if(Session::has('message'))


            <div class="alert alert-success">{{ Session::get('message') }}</div>


        @endif


@if($gallery->count())


<table class="table table-hover table-striped">


    <thead>


    <tr>


        <th>#</th>


        <th>Başlık</th>


        <th class="text-center">Ekleyen</th>


        <th class="text-center">Tarih</th>


    </tr>


    </thead>


    <tbody>


    @foreach($gallery as $gal)


    <tr>


        <td style="width: 75px;"><img width="100" height="75" src="{{ Gallery::getThumb($gal->id, $gal->cover) }}"></td>


        <td><a href="{{ URL::to('component/gallery/edit/'.$gal->id) }}">{{ $gal->title }}</a></td>


        <td class="text-center">{{ $gal->user->name }}</td>


        <td class="text-center"><abbr class="timeago" title="{{ $gal->created_at }}">{{ $gal->created_at }}</abbr></td>


    </tr>


   @endforeach


    </tbody>


</table>





        {{ $gallery->links() }}


@else


        <div class="alert alert-warning">


            <h4>Hiç resminiz yok.</h4> <a href="{{ URL::to('component/gallery/create') }}" class="alert-link">Buradan ekleyin</a>


        </div>


@endif








    </div>





@stop