@extends('layouts.wrap')





@section('title', $gallery->title.'- Düzenle')








@include('gallery::sidebar')





@include('assets/jqueryUI')











@section('foot_hook')


@parent


<script>





    CKEDITOR.replace('value', {


        filebrowserUploadUrl: '/component/page/uploader/{{Request::segment(4)}}',


        height: '200px'


    });





</script>


@stop





@include('assets.form.ckeditor')








@section('_content')


<div id="component_gallery">


<h1 class="title">{{ $gallery->title }} <a  data-toggle="modal" data-target="#confirm-delete" class="pull-right btn-xs btn-danger btn"><i class="fa fa-trash-o"></i> Galeriyi Sil</a></h1>








    @if(Session::has('message'))


        <div class="alert alert-success">


            {{ Session::get('message') }}


        </div>


    @endif











{{ Former::open_for_files()->method('POST')->action(URL::to('component/gallery/upload'))->id('uploader') }}


    <div class="form-group">


        <label for="title" class="control-label">Resimler</label>


        <input type="file" id="images" name="images[]" multiple accept="image/*">


    </div>





    <div class="form-group hide uprog">


        <div class="progress progress-striped active">


            <div id="prog" class="progress-bar progress-bar-danger"  role="progressbar" style="width: 45%">


                <span class="sr-only">45%</span>


            </div>


        </div>


    </div>


{{ Former::close() }}





    {{ Former::open()->method('POST')->action(URL::to('component/gallery/edit/'.$gallery->id)) }}





    <div class="form-group">


        <label for="value" class="control-label">Açıklama</label>


        <textarea id="value" name="value" class="form-control">{{ $gallery->value }}</textarea>


    </div>





    {{ Former::text('title')->label('Galeri Başlığı')->placeholder('Galeri Başlığı')->required(true)->value($gallery->title) }}





<div class="row" id="images-sort" style="min-height: 200px;">








    @foreach($gallery->images as $image => $desc)


        <div class="col-xs-6 col-md-3">


            <div class="thumbnail list" style="background: url('{{ Gallery::getThumb($gallery->id, $image) }}');">


                <a class="label label-danger parent-deleter pull-right">


                    <i class="fa fa-trash-o"></i></a>


                <a class="handler"></a>


                <input value="{{$image}}" type="hidden" name="images[]"><input value="{{$desc}}" name="description[{{$image}}]" type="text" class="form-control input-sm" placeholder="Açıklama">


            </div>


        </div>


    @endforeach








</div>


<button type="submit" class="btn btn-danger">Değişiklikleri Kaydet</button>





{{ Former::close() }}





</div>











<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">


    <div class="modal-dialog">


        <div class="modal-content">





            <div class="modal-header">


                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>


                <h4 class="modal-title" id="myModalLabel">Silmeyi Onaylıyormusun ?</h4>


            </div>





            <div class="modal-body">


                <p>Galeriyi silmeniz resimlerin geri dönüşü olmadan silinmesine neden olacaktır</p>


                <p>İşleme devam edilsin mi?</p>


            </div>





            <div class="modal-footer">


                <button type="button" class="btn btn-default" data-dismiss="modal">Hayır</button>


                <a href="{{ URL::to('component/gallery/delete/'.$gallery->id) }}" class="btn btn-danger danger">Sil</a>


            </div>


        </div>


    </div>


</div>














@stop