@extends('layouts.wrap')





@section('title', $contact->title)














@section('foot_hook')


@parent


<script>


    var geocoder;


    var map;


    var hasMarker = false;


    function initialize() {


        geocoder = new google.maps.Geocoder();


        var latlng = new google.maps.LatLng{{ $contact->map }};


        var mapOptions = {


            zoom: 15,


            center: latlng


        }


        map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);





        marker = new google.maps.Marker({


            map: map,


            position: latlng,


            draggable: true


        });





        google.maps.event.addListener(marker, 'dragend', function(e) {





            $('#map').val(marker.position.toString());





        } );





    }





    function codeAddress() {


        var address = document.getElementById('stradd').value;


        geocoder.geocode( { 'address': address}, function(results, status) {


            if (status == google.maps.GeocoderStatus.OK) {


                map.setCenter(results[0].geometry.location);





                $('#map').val(results[0].geometry.location.toString());








                       marker.setPosition(results[0].geometry.location);














            } else {


                alert('Geocode was not successful for the following reason: ' + status);


            }


        });


    }





    google.maps.event.addDomListener(window, 'load', initialize);





</script>


@stop


@include('contact::sidebar')





@section('_content')





<div id="component_gallery">


<h1 class="title">{{ $contact->title }} <a  data-toggle="modal" data-target="#confirm-delete" class="pull-right btn-xs btn-danger btn"><i class="fa fa-trash-o"></i> Adresi Sil</a></h1>





{{ Former::open()->method('POST')->action(URL::to('component/contact/edit/'. $contact->id)) }}





    {{ Former::text('title')->label('Adres Başlığı')->placeholder('Adres Başlığı')->required(true)->value($contact->title) }}


    {{ Former::textarea('address')->label('Adres Tanımı')->placeholder('Adres Tanımı')->required(true)->rows(3)->value($contact->address) }}


    {{ Former::text('phone')->label('Telefon')->placeholder('Telefon')->required(true)->value($contact->phone) }}


    {{ Former::text('fax')->label('fax')->placeholder('fax')->required(true)->value($contact->fax) }}


    {{ Former::text('email')->label('email')->placeholder('email')->required(true)->value($contact->email) }}





    <div classs="form-group clearfix">


        <div id="panel">


            <label>Adres Bul</label>


            <div class="input-group">


                 <span class="input-group-btn">


                   <a class="btn btn-warning" onclick="codeAddress()">Adresi Getir</a>


                 </span>


                <input class="form-control" id="stradd" type="textbox" value="Ankara, Öveçler">


            </div>


            <input type="hidden" id="map" name="map" value="{{ $contact->map }}">


        </div>


        <div style="height: 300px;" id="map-canvas"></div>


    </div>





    <button type="submit" class="btn btn-danger">Değişiklikleri Kaydet</button>





{{ Former::close() }}





    </div>








<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">


    <div class="modal-dialog">


        <div class="modal-content">





            <div class="modal-header">


                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>


                <h4 class="modal-title" id="myModalLabel">Silmeyi Onaylıyormusun ?</h4>


            </div>





            <div class="modal-body">


                <p>İşleme devam edilsin mi?</p>


            </div>





            <div class="modal-footer">


                <button type="button" class="btn btn-default" data-dismiss="modal">Hayır</button>


                <a href="{{ URL::to('component/contact/delete/'.$contact->id) }}" class="btn btn-danger danger">Sil</a>


            </div>


        </div>


    </div>


</div>














@stop