@extends('layouts.wrap')





@section('title', 'Yeni Adres Ekle')














@section('foot_hook')


@parent


<script>


    var geocoder;


    var map;


    var hasMarker = false;


    function initialize() {


        geocoder = new google.maps.Geocoder();


        var latlng = new google.maps.LatLng(39.9033765, 32.767873);


        var mapOptions = {


            zoom: 13,


            center: latlng


        }


        map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);


    }





    function codeAddress() {


        var address = document.getElementById('stradd').value;


        geocoder.geocode( { 'address': address}, function(results, status) {


            if (status == google.maps.GeocoderStatus.OK) {


                map.setCenter(results[0].geometry.location);





                $('#map').val(results[0].geometry.location.toString());





                    if(hasMarker === false){


                        marker = new google.maps.Marker({


                            map: map,


                            position: results[0].geometry.location,


                            draggable: true


                        });





                        google.maps.event.addListener(marker, 'dragend', function(e) {





                            $('#map').val(marker.position.toString());





                        } );





                        hasMarker = true;


                    }else{


                       marker.setPosition(results[0].geometry.location);


                    }














            } else {


                alert('Geocode was not successful for the following reason: ' + status);


            }


        });


    }





    google.maps.event.addDomListener(window, 'load', initialize);





</script>


@stop


@include('contact::sidebar')





@section('_content')





<div id="component_gallery">


<h1 class="title">Adres Ekle</h1>





{{ Former::open()->method('POST')->action(URL::to('component/contact/create')) }}





    {{ Former::text('title')->label('Adres Başlığı')->placeholder('Adres Başlığı')->required(true) }}


    {{ Former::textarea('address')->label('Adres Tanımı')->placeholder('Adres Tanımı')->required(true)->rows(3) }}


    {{ Former::text('phone')->label('Telefon')->placeholder('Telefon')->required(true) }}


    {{ Former::text('fax')->label('fax')->placeholder('fax')->required(true) }}


    {{ Former::text('email')->label('email')->placeholder('email')->required(true) }}





    <div classs="form-group clearfix">


        <div id="panel">


            <label>Adres Bul</label>


            <div class="input-group">


                 <span class="input-group-btn">


                   <a class="btn btn-warning" onclick="codeAddress()">Adresi Getir</a>


                 </span>


                <input class="form-control" id="stradd" type="textbox" value="Ankara, Öveçler">


            </div>


            <input type="hidden" id="map" name="map">


        </div>


        <div style="height: 300px;" id="map-canvas"></div>


    </div>





    <button type="submit" class="btn btn-danger">Oluştur</button>





{{ Former::close() }}





    </div>





@stop